/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.ProcessResultsApp;
import com.ibm.hwmca.fw.tasklet.TaskletClientExitInterface;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class ResultsProcessor
implements TaskletClientExitInterface {
    private static final String TRACE_MASKT = "XFRMRPRT";
    private static final String TRACE_MASKF = "XFRMRPRF";
    private static final String TRACE_MASKD = "XFRMRPRD";
    private CompletionReport[] reportsToExamine;
    private boolean allowCancel;
    private LocalizableText[] names;
    ArrayList badReports;
    ArrayList badNames;
    ArrayList goodReports;
    public static final String RESULTS_RES = "com.ibm.hwmca.fw.task.res.ProcessResultsRes";
    public static final String KEY_UNNAMED_REPORT = "ResultsPanel.unnamedreport";
    public static final String KEY_UNKNOWN_ERROR = "ResultsPanel.unknownerror";
    private Class resultClass;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$report$CompletionReport;

    public ResultsProcessor(CompletionReport[] reportsToExamine, boolean allowCancel) {
        Trace.trace(TRACE_MASKT, "-> ResultsProcessor()");
        this.reportsToExamine = reportsToExamine;
        this.allowCancel = allowCancel;
        if (reportsToExamine != null) {
            this.names = new LocalizableText[reportsToExamine.length];
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            int i = 0;
            while (i < reportsToExamine.length) {
                HwmcaObject hObj;
                ObjectId objId = reportsToExamine[i].getObjectId();
                this.names[i] = objId == null ? new LocalizableText(RESULTS_RES, KEY_UNNAMED_REPORT, new String[]{new Integer(i).toString()}) : ((hObj = mom.get(reportsToExamine[i].getObjectId())) == null ? new LocalizableText(RESULTS_RES, KEY_UNNAMED_REPORT, new String[]{new Integer(i).toString()}) : (hObj.getUIInfo() == null || hObj.getUIInfo().getUnlocalizedName() == null ? new LocalizableText("" + i) : hObj.getUIInfo().getUnlocalizedName()));
                ++i;
            }
        }
        this.badReports = new ArrayList();
        this.badNames = new ArrayList();
        this.goodReports = new ArrayList();
        if (reportsToExamine != null) {
            int i = 0;
            while (i < reportsToExamine.length) {
                if (reportsToExamine[i] == null || reportsToExamine[i].getCompletionCode() == null || !reportsToExamine[i].getCompletionCode().equals(CompletionReportCode.SUCCESS)) {
                    this.badReports.add(reportsToExamine[i]);
                    this.badNames.add(this.names[i]);
                } else {
                    this.goodReports.add(reportsToExamine[i]);
                }
                ++i;
            }
            Trace.trace(TRACE_MASKF, "Total number of reports to examine: " + reportsToExamine.length);
            Trace.trace(TRACE_MASKF, "Number of good reports: " + this.goodReports.size());
            Trace.trace(TRACE_MASKF, "Number of bad reports: " + this.badReports.size());
        }
        Trace.trace(TRACE_MASKT, "<- ResultsProcessor()");
    }

    public ResultsProcessor(CompletionReport[] reportsToExamine, boolean allowCancel, Class resultClass) {
        this(reportsToExamine, allowCancel);
        if (resultClass == null) {
            Trace.trace(TRACE_MASKF, "resultClass was null, defaulting to CompletionReport");
        } else if (!(class$com$ibm$hwmca$fw$report$CompletionReport == null ? (class$com$ibm$hwmca$fw$report$CompletionReport = ResultsProcessor.class$("com.ibm.hwmca.fw.report.CompletionReport")) : class$com$ibm$hwmca$fw$report$CompletionReport).isAssignableFrom(resultClass)) {
            Trace.trace(TRACE_MASKF, "resultClass doesn't derive from CompletionReport, defaulting back to CompletionReport");
        } else {
            this.resultClass = resultClass;
        }
    }

    public Object exit() {
        Trace.trace(TRACE_MASKT, "<> exit()");
        if (this.reportsToExamine == null || this.reportsToExamine.length == 0) {
            return new CompletionReport[0];
        }
        if (this.badReports.size() == 0) {
            return this.reportsToExamine;
        }
        String answer = null;
        try {
            answer = ProcessResultsApp.showPanel(this.badReports.toArray(new CompletionReport[0]), this.badNames.toArray(new LocalizableText[0]), this.allowCancel);
            Trace.trace(TRACE_MASKF, "ProcessResults: got answer from msg box: " + answer);
            if (answer == null || answer.equals("OKButton")) {
                if (this.resultClass != null) {
                    CompletionReport[] result = (CompletionReport[])Array.newInstance(this.resultClass, this.goodReports.size());
                    int i = 0;
                    while (i < this.goodReports.size()) {
                        result[i] = (CompletionReport)this.goodReports.get(i);
                        ++i;
                    }
                    return result;
                }
                return this.goodReports.toArray(new CompletionReport[this.goodReports.size()]);
            }
            if (this.resultClass != null) {
                CompletionReport[] result = (CompletionReport[])Array.newInstance(this.resultClass, 0);
                return result;
            }
            return new CompletionReport[0];
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "ProcessResults.exit(): Exception showing message box");
            Trace.trace(TRACE_MASKF, e);
            if (this.resultClass != null) {
                CompletionReport[] result = (CompletionReport[])Array.newInstance(this.resultClass, 0);
                return result;
            }
            return new CompletionReport[0];
        }
    }

    public int getNumberTotalReports() {
        if (this.reportsToExamine == null) {
            return 0;
        }
        return this.reportsToExamine.length;
    }

    public int getNumberGoodReports() {
        return this.goodReports.size();
    }

    public int getNumberBadReports() {
        return this.badReports.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

